//=============================================================================
// Portal Gun
//=============================================================================
class MSPortalGun extends DeusExWeapon;

#exec TEXTURE IMPORT NAME="YellowPortal" FILE="C:\DeusEx\MSPortalGun\Textures\YellowPortal.pcx" GROUP=Skins FLAGS=2
#exec TEXTURE IMPORT NAME="BluePortal" FILE="C:\DeusEx\MSPortalGun\Textures\BluePortal.pcx" GROUP=Skins FLAGS=2

var YellowPortal yportal;
var BluePortal bportal;
var travel byte XMode;
var localized String msgPortalFailure;
var localized String msgHasPortals;
var Bool yportalexists;
var Bool bportalexists;

function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
  if (XMode == 0)
  {
   if ((Other != None) && Other.IsA('Pawn') || Other.IsA('Decoration') || Other.IsA('PortalBlocker'))
   {
		Pawn(Owner).ClientMessage(msgPortalFailure);
		return;
   }
   else
   {
    if (!bportalexists)
    {
    XMode = 1;
    spawn(class'MSPortalGun.BluePortal',,,HitLocation);
    bportalexists = True;
    }
    else if (bportalexists)
    {
    Pawn(Owner).ClientMessage(msgHasPortals);
    }
   }
  }
  else if (XMode == 1)
  {
   if ((Other != None) && Other.IsA('Pawn') || Other.IsA('Decoration') || Other.IsA('PortalBlocker'))
   {
		Pawn(Owner).ClientMessage(msgPortalFailure);
		return;
   }
   else
   {
    if (!yportalexists)
    {
    XMode = 0;
    spawn(class'MSPortalGun.YellowPortal',,,HitLocation);
    yportalexists = True;
    }
    else if (yportalexists)
    {
    Pawn(Owner).ClientMessage(msgHasPortals);
    }
   }
  }
 }

function LaserToggle()
{
    ForEach AllActors(class'YellowPortal',yportal)
    {
    if (yportal != None) 
      {
      yportal.Destroy();
      }
    yportalexists = False;
    }
    ForEach AllActors(class'BluePortal',bportal)
    {    
    if (bportal != None) 
      {
      bportal.Destroy();
      }
    bportalexists = False;
    }
    XMode=0;
}

defaultproperties
{
     LowAmmoWaterMark=4
     GoverningSkill=Class'DeusEx.SkillWeaponHeavy'
     NoiseLevel=0.000000
     EnviroEffective=ENVEFF_Air
     ShotTime=1.900000
     reloadTime=0.000001
     HitDamage=300
     maxRange=24000
     AccurateRange=14400
     bCanHaveScope=True
     bHasMuzzleFlash=False
     recoilStrength=1.000000
     bUseWhileCrouched=False
     mpHitDamage=40
     mpAccurateRange=14400
     mpMaxRange=14400
     mpReloadCount=1
     bCanHaveModAccurateRange=True
     bCanHaveModReloadTime=True
     AmmoName=Class'MSPortalGun.AmmoPortal'
     ReloadCount=1
     PickupAmmoCount=32767
     bInstantHit=True
     FireOffset=(X=-46.000000,Y=22.000000,Z=10.000000)
     ProjectileClass=None
     shakemag=0.000000
     FireSound=Sound'DeusExSounds.Weapons.LAWFire'
     SelectSound=Sound'DeusExSounds.Weapons.LAWSelect'
     InventoryGroup=255
     ItemName="Portal Gun"
     PlayerViewOffset=(X=18.000000,Y=-18.000000,Z=-7.000000)
     PlayerViewMesh=LodMesh'DeusExItems.LAW'
     PickupViewMesh=LodMesh'DeusExItems.LAWPickup'
     ThirdPersonMesh=LodMesh'DeusExItems.LAW3rd'
     LandSound=Sound'DeusExSounds.Generic.DropLargeWeapon'
     Icon=Texture'DeusExUI.Icons.BeltIconLAW'
     largeIcon=Texture'DeusExUI.Icons.LargeIconLAW'
     largeIconWidth=166
     largeIconHeight=47
     invSlotsX=4
     Description="A mysterious gun that seems remotely familiar..."
     beltDescription="PORTAL"
     Mesh=LodMesh'DeusExItems.LAWPickup'
     CollisionRadius=27.000000
     CollisionHeight=6.600000
     Mass=5.000000
     msgPortalFailure="Invalid Location."
     msgHasPortals="Portals already in use."
     bCanHaveScope=True
     bHasScope=True
     BaseAccuracy=0.000000
}
